library(PointFore)

# Define helper function --------------------------------------------------


GDPanalyse <- function(model, instruments, forecast, iden.fct=quantiles,...)
{
  estimate.functional(iden.fct = iden.fct,
                             model = model,
                             centeredVcov=FALSE,
                             instruments = instruments,
                             Y = GDP$observation,X = forecast,
                             stateVariable = forecast,...)
}

test <- function(string,res)
{
  return(car::linearHypothesis(res$gmm,string))
}

conf <- function(res,name,level=0.90)
{
  confint(res$gmm,parm=name,level=level)
}

# Define instruments ------------------------------------------------------

early <- c("X","lag(Y)")
standard <- c("X","lag(lag(Y))")
simulation <- c("lag(Y)","X","X^2","X^3","lag(Y-X)","lag(Y-X)^2")



# Analyse - constant model ------------------------------------------------

summary(GDPanalyse(constant,standard,GDP$forecast))
#0.05
test("Theta[1]=.5",GDPanalyse(constant,standard,GDP$forecast))
#0.01


summary(GDPanalyse(constant,standard,GDP$forecast_late))
#0.30
test("Theta[1]=.5",GDPanalyse(constant,standard,GDP$forecast_late))
#0.02
conf(GDPanalyse(constant,standard,GDP$forecast_late), "Theta[1]")

res <- GDPanalyse(constant,standard,GDP$forecast_late)
conf(res,"Theta[1]")

res <- GDPanalyse(constant,standard,GDP$forecast_late)
summary(res)$Jtest
conf(res,"Theta[1]")
conf(res,"Theta[1]",level = 0.6)
test("Theta[1]=.5",res)


res <- GDPanalyse(constant,standard,GDP$forecast)
summary(res)$Jtest
conf(res,"Theta[1]")
test("Theta[1]=.5",res)




# Analyse - linear probit -------------------------------------------------
library(ggplot2)

res <- GDPanalyse(probit_linear,standard,GDP$forecast)
summary(res)
res$gmm$vcov
plot(res,limits=c(-5,10),hline=TRUE)+  xlab("predicted growth rate")+
  theme_classic(20)+
  scale_y_continuous("quantile level", limits=c(0,1))

#ggsave('./data-raw/GDP_newInstruments.pdf', height = 5, width=8)

res <- GDPanalyse(probit_linear,standard,GDP$forecast_late)
summary(res)
plot(res,hline = TRUE)



# Analyse - linear probit with state y ------------------------------------

res <- estimate.functional(iden.fct = quantiles,
                    model = probit_linear,
                    instruments = standard,
                    Y = GDP$observation, X = GDP$forecast,
                    stateVariable = lag(GDP$observation))
summary(res)
plot(res,hline=TRUE)


res <- estimate.functional(iden.fct = quantiles,
                           model = probit_linear,
                           instruments = early,
                           Y = GDP$observation, X = GDP$forecast,
                           stateVariable = lag(GDP$observation))
summary(res)
plot(res,hline=TRUE)


res <- estimate.functional(iden.fct = quantiles,
                           model = probit_linear,
                           instruments = standard,
                           Y = GDP$observation, X = GDP$forecast,
                           stateVariable = lag(lag(GDP$observation)))
summary(res)
plot(res,hline=TRUE)



# Analyse - linear probit with early instrument ---------------------------

res <- GDPanalyse(probit_linear,early,GDP$forecast)
summary(res)
plot(res,hline = TRUE)

res <- GDPanalyse(probit_linear,early,GDP$forecast_late)
summary(res)
plot(res,hline = TRUE)



# time series -------------------------------------------------------------



ggplot(GDP)+
  geom_line(aes(x=date,y=observation))+
  geom_point(aes(x=date,y=forecast), color = 'red', size = 2, shape=4)

p <- ggplot(GDP)+
  geom_line(aes(x=date,y=observation))+geom_hline(yintercept = 0,color="grey")+
  geom_point(aes(x=date,y=forecast), color = 'red', size = 2, shape=4)+
  ylab('GDP growth')+
  xlab('')+
  theme_classic(15)
p
ggsave(p, filename = 'gdp_line.pdf', width = 10, height = 3)

